//=============================================================================
// PictureFilter.js
//=============================================================================

/*:
 * @plugindesc Apply saturation and brightness filters to all pictures.
 * @author [Your Name]
 *
 * @help This plugin allows you to adjust the saturation and brightness of
 * all pictures on the screen.
 *
 * @param DefaultSaturation
 * @text Default Saturation
 * @desc Default saturation value (0 to 100).
 * @default 0
 *
 * @param DefaultBrightness
 * @text Default Brightness
 * @desc Default brightness value (0 to 100).
 * @default 0
 *
 * @command adjustPictureFilters
 * @text Adjust Picture Filters
 * @desc Adjusts saturation and brightness of all pictures.
 *
 * @arg saturation
 * @text Saturation
 * @desc Saturation value (0 to 100).
 * @default 0
 *
 * @arg brightness
 * @text Brightness
 * @desc Brightness value (0 to 100).
 * @default 0
 */

(function() {
    var parameters = PluginManager.parameters('PictureFilter');
    var defaultSaturation = parseInt(parameters['DefaultSaturation']);
    var defaultBrightness = parseInt(parameters['DefaultBrightness']);

    // Register plugin command
    PluginManager.registerCommand('PictureFilter', 'adjustPictureFilters', function(args) {
        var saturation = parseInt(args.saturation);
        var brightness = parseInt(args.brightness);
        applyPictureFilters(saturation, brightness);
    });

    function applyPictureFilters(saturation, brightness) {
        var pictures = SceneManager._scene._spriteset._pictureContainer.children;
        pictures.forEach(function(picture) {
            if (picture.bitmap) {
                var context = picture.bitmap.context;
                context.filter = 'saturate(' + saturation + '%) brightness(' + brightness + '%)';
                picture.bitmap._setDirty();
            }
        });
    }

    // Apply default filters on game start
    applyPictureFilters(defaultSaturation, defaultBrightness);
